import objectos_casa.End_if;
import objectos_casa.ObjectoCasa;
import objectos_casa.Begin_switch;
import objectos_casa.End_switch;

/**
 * Created by Pedro on 24/04/2016.
 */
public class LeitorCasa {

    char char_indent;
    public LeitorCasa(){
        char_indent='\t';
    }

    public  LeitorCasa(char char_indentacao){
        char_indent=char_indentacao;
    }

    public String repeatChar(char c, int vezes){
        String retorno="";
        if(vezes>0)
            for(int i=0;i<vezes;i++)
                retorno+=c;
        return retorno;
    }

    public String gerar_tabulado(ObjectoCasa obj, int indentacao){
        String codigo_gerado;
        codigo_gerado=obj.gerar();
        if(codigo_gerado.equals(""))
            return codigo_gerado;
        else
            return repeatChar(char_indent,indentacao)+codigo_gerado;
    }

    public String ler_casa(Casa c, Boolean print_coords) {
        String codigo_casa = "";
        int valor_indent = 0;
        int pos_y=0;



        for (int pos_x = 0; pos_x < c.tamanho_x; pos_x++){

            if(c.casa[pos_x][pos_y].tipo_objecto().equals("null")) {
                if (pos_y > 0)
                    pos_y--;
                else
                    return codigo_casa;
            }


            switch (c.casa[pos_x][pos_y].tipo_objecto()) {

                case "def_func":
                    codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                    valor_indent++;
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    break;

                case "begin_if":
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                    pos_y++;
                    valor_indent++;
                    break;

                case "end_if":
                    valor_indent--;
                    End_if temp_if=(End_if)c.casa[pos_x][pos_y];
                    int coord_if=temp_if.getCoord();
                    Boolean else_com_objectos=false;
                    for(int i=coord_if+1;i<pos_x;i++)
                        if(!c.casa[i][pos_y].tipo_objecto().equals("blank")) {
                            else_com_objectos = true;
                            break;
                        }

                    if(coord_if>0 && else_com_objectos){
                        pos_x=coord_if;
                        temp_if.setCoord(0);
                        c.casa[pos_x][pos_y]=temp_if;
                        codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                        valor_indent++;
                    }
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    break;

                case "begin_while_ciclo": case"begin_for_ciclo":
                    codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                    valor_indent++;
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    break;

                case "end_ciclo":
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    valor_indent--;
                    break;

                case "begin_switch":
                    if(((Begin_switch)c.casa[pos_x][pos_y]).getLido()) {
                        ((Begin_switch)c.casa[pos_x][pos_y]).setLido(false);

                        Boolean else_switch_com_objectos=false;
                        for(int i=pos_x+1;i<c.tamanho_x;i++) {
                            if (c.casa[i][pos_y].tipo_objecto().equals("end_switch"))
                                break;
                            if (!c.casa[i][pos_y].tipo_objecto().equals("blank")) {
                                else_switch_com_objectos = true;
                                break;
                            }
                        }
                        if(else_switch_com_objectos)
                            codigo_casa += gerar_tabulado(c.casa[pos_x][pos_y], valor_indent);

                        valor_indent++;

                    }
                    else{
                        if(print_coords)
                            codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                        ((Begin_switch)c.casa[pos_x][pos_y]).setLido(true);
                        while(pos_y<c.tamanho_y) {
                            if(c.casa[pos_x][pos_y].tipo_objecto().equals("null")) {
                                pos_y--;
                                break;
                            }
                            pos_y++;
                        }
                        pos_x--;


                    }
                    break;

                case "switch_case":
                    codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                    valor_indent++;
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    break;

                case "end_switch":
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    End_switch temp_end_switch =(End_switch)c.casa[pos_x][pos_y];
                    int coord_switch= temp_end_switch.getCoord();
                    valor_indent--;
                    if(coord_switch>0){
                        pos_x=coord_switch-1;
                        pos_y--;
                    }
                    break;

                default:
                    if(print_coords)
                        codigo_casa+=repeatChar(char_indent,valor_indent)+"print (\'[\'+str("+pos_x+")+\',\'+str("+pos_y+")+\']\')\n";
                    codigo_casa+=gerar_tabulado(c.casa[pos_x][pos_y],valor_indent);
                    break;
            }

        }
        return codigo_casa;
    }

}
